/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.handlers;

import java.util.Map;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import xzeroair.trinkets.util.handlers.Counter;

public class TickHandler {
    Map<String, Counter> Counters = new TreeMap<String, Counter>();

    public Map<String, Counter> getCounters() {
        return this.Counters;
    }

    public void addCounter(String key, int length, boolean countdown, boolean shouldTick, boolean saveToNBT) {
        if (this.Counters != null && !this.Counters.containsKey(key)) {
            this.Counters.put(key, new Counter(key, length, countdown, shouldTick, saveToNBT));
        }
    }

    public void removeCounter(String key) {
        if (!this.Counters.isEmpty() && this.Counters.containsKey(key)) {
            this.Counters.remove(key);
        }
    }

    public void clearCounters() {
        if (!this.Counters.isEmpty()) {
            this.Counters.clear();
        }
    }

    public Counter getCounter(String key, int length, boolean isCountdown, boolean shouldTick, boolean create, boolean saveNBT) {
        return this.getCounter(key, length, isCountdown, shouldTick, true, create, saveNBT);
    }

    public Counter getCounter(String key, int length, boolean isCountdown, boolean shouldTick, boolean autoReset, boolean create, boolean saveNBT) {
        if (!this.Counters.isEmpty() && this.Counters.containsKey(key)) {
            return this.Counters.get(key);
        }
        if (create) {
            Counter value = new Counter(key, length, isCountdown, shouldTick, autoReset, saveNBT);
            this.Counters.put(key, value);
            return value;
        }
        return null;
    }

    public Counter getCounter(String key) {
        if (!this.Counters.isEmpty() && this.Counters.containsKey(key)) {
            return this.Counters.get(key);
        }
        return null;
    }

    public void saveCountersToNBT(NBTTagCompound compound) {
        NBTTagCompound counters = new NBTTagCompound();
        for (Map.Entry<String, Counter> counter : this.Counters.entrySet()) {
            String name = counter.getValue().getName();
            int tick = counter.getValue().getTick();
            int length = counter.getValue().getLength();
            boolean countdown = counter.getValue().getCountdown();
            boolean shouldTick = counter.getValue().shouldTick();
            boolean saveToNBT = counter.getValue().saveToNBT();
            if (!saveToNBT) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("Tick", tick);
            nbt.func_74768_a("Length", length);
            nbt.func_74757_a("Countdown", countdown);
            nbt.func_74757_a("ShouldTick", shouldTick);
            counters.func_74782_a(name, (NBTBase)nbt);
        }
        compound.func_74782_a("Counters", (NBTBase)counters);
    }

    public void loadCountersFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("Counters")) {
            NBTTagCompound counters = compound.func_74775_l("Counters");
            counters.func_150296_c().forEach(name -> {
                try {
                    NBTTagCompound counter = counters.func_74775_l(name);
                    int tick = counter.func_74762_e("Tick");
                    int length = counter.func_74762_e("Length");
                    boolean countdown = counter.func_74767_n("Countdown");
                    boolean shouldTick = counter.func_74767_n("ShouldTick");
                    Counter nbtCounter = new Counter((String)name, length, countdown, shouldTick).setTick(tick);
                    if (this.Counters.containsKey(name)) {
                        this.Counters.replace((String)name, nbtCounter);
                    } else {
                        this.Counters.putIfAbsent((String)name, nbtCounter);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }
}

